<?php

class EWRporta_Install
{
	public static function installCode()
	{
		$db = XenForo_Application::get('db');

 		$db->query("
			CREATE TABLE IF NOT EXISTS `EWRporta_cache` (
				`page_id`			int(10) unsigned					NOT NULL,
				`cache_date`		int(10) unsigned					NOT NULL,
				`cache_content`		mediumtext							NOT NULL,
				PRIMARY KEY (`page_id`)
			) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
		");

 		$db->query("
			CREATE TABLE IF NOT EXISTS `EWRporta_history` (
				`page_id`			int(10) unsigned					NOT NULL,
				`user_id`			int(10) unsigned					NOT NULL,
				`username`			varchar(50)							NOT NULL,
				`history_id`		int(10) unsigned					NOT NULL AUTO_INCREMENT,
				`history_date`		int(10) unsigned					NOT NULL,
				`history_type`		enum('bbcode', 'html', 'phpfile')	NOT NULL,
				`history_content`	mediumtext							NOT NULL,
				PRIMARY KEY (`history_id`),
				INDEX (`page_id`),
				INDEX (`user_id`)
			) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
		");
 		$db->query("ALTER TABLE `EWRporta_history` CHANGE `history_type` `history_type` ENUM('bbcode', 'html', 'phpfile') NOT NULL");
 		$db->query("ALTER TABLE `EWRporta_history` ADD `history_current` int(1) unsigned NOT NULL DEFAULT '0'");

 		$db->query("
			CREATE TABLE IF NOT EXISTS `EWRporta_pages` (
				`page_id`			int(10) unsigned					NOT NULL AUTO_INCREMENT,
				`page_slug`			varchar(100)						NOT NULL,
				`page_name`			varchar(100)						NOT NULL,
				`page_date` 		int(10) unsigned					NOT NULL,
				`page_type` 		enum('bbcode', 'html', 'phpfile')	NOT NULL DEFAULT 'bbcode',
				`page_content`		mediumtext							NOT NULL,
				`page_parent`		int(10) unsigned					NOT NULL DEFAULT '0',
				PRIMARY KEY (`page_id`),
				UNIQUE KEY (`page_slug`),
				INDEX (`page_parent`)
			) ENGINE = MyISAM CHARACTER SET utf8 COLLATE utf8_general_ci
		");
 		$db->query("ALTER TABLE `EWRporta_pages` CHANGE `page_type` `page_type` ENUM('bbcode', 'html', 'phpfile') NOT NULL DEFAULT 'bbcode'");
 		$db->query("ALTER TABLE `EWRporta_pages` ADD FULLTEXT(`page_name`)");
 		$db->query("ALTER TABLE `EWRporta_pages` ADD FULLTEXT(`page_name`)");
 		$db->query("INSERT IGNORE INTO `EWRporta_pages` (`page_slug`, `page_name`, `page_date`, `page_content`) VALUES ('index', 'Index', '0', 'Index')");

 		$db->query("
			CREATE TABLE IF NOT EXISTS `EWRporta_templates` (
				`template_name`		varchar(100)						NOT NULL,
				`template_content`	mediumtext							NOT NULL,
				PRIMARY KEY (`template_name`)
			) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
		");
 		$db->query("INSERT IGNORE INTO `EWRporta_templates` (`template_name`, `template_content`)
			VALUES ('gallery', '<a class=\"highslide\" href=\"gallery/{{{url}}}\" onclick=\"return hs.expand(this)\"><img src=\"gallery/_thumbs/{{{url}}}\" alt=\"{{{url}}}\" style=\"max-height: 120px;\" /></a>')");

		return true;
	}

	public static function uninstallCode()
	{
		$db = XenForo_Application::get('db');

 		$db->query("
			DROP TABLE IF EXISTS
				`EWRporta_cache`,
				`EWRporta_history`,
				`EWRporta_pages`,
				`EWRporta_templates`;
		");

		return true;
	}
}